import os
from sqlalchemy import create_engine, Column, String, DateTime
from sqlalchemy.orm import declarative_base, sessionmaker

DB_PATH = os.path.join("config", "lock.db")
os.makedirs("config", exist_ok=True)

engine = create_engine(f"sqlite:///{DB_PATH}", connect_args={"check_same_thread": False})
SessionLocal = sessionmaker(bind=engine)
Base = declarative_base()

class Lock(Base):
    __tablename__ = "locks"
    path = Column(String, primary_key=True, index=True)
    owner = Column(String)
    token = Column(String, unique=True)
    timeout = Column(DateTime)

def init_db():
    Base.metadata.create_all(bind=engine)

